
// Reference to the creative's various properties and elements.
var creative = {};


/**
 * Called on the window load event.
 */
function preInit() {
  setupDom();

  if (Enabler.isInitialized()) {
    init();
  } else {
    Enabler.addEventListener(
      studio.events.StudioEvent.INIT,
      init
    );
  }
}

/**
 * Set up references to DOM elements.
 */
function setupDom() {
  creative.dom = {};
  /*
  creative.dom.mainContainer = document.getElementById('main-container');
  creative.dom.exit = document.getElementById('exit');
  creative.dom.image0 = document.getElementById('main-img-0');
*/
  creative.dom.banner = document.getElementById("banner");
  creative.dom.bg = document.getElementById("bg");
  creative.dom.cta = document.getElementById("cta");
  creative.dom.textWrapper = document.getElementById("typed-wrapper");
  creative.dom.txt1 = document.getElementById("txt1");
  creative.dom.txt2 = document.getElementById("txt2");
  creative.dom.txt3 = document.getElementById("txt3");
  creative.dom.txt4 = document.getElementById("txt4");
  creative.dom.txt5 = document.getElementById("txt5");
  creative.dom.txt6 = document.getElementById("txt6");
}
/**
 * The Enabler is now initialized and any extra modules have been loaded.
 */
function init() {
  addListeners();
  // Polite loading
  if (Enabler.isVisible()) {
    show();
  }
  else {
    Enabler.addEventListener(studio.events.StudioEvent.VISIBLE, show);
  }
}

/**
 * Add appropriate listeners after the creative's DOM has been set up.
 */
function addListeners() {
  creative.dom.banner.addEventListener('click', exitClickHandler);
}

/**
 *  Shows the ad.
 */
 
function show() {

  creative.dom.banner.style.display = "block";

  TweenLite.to(creative.dom.cta, 0, {right:"-"+creative.dom.cta.clientWidth+"px"});
  TweenLite.to(creative.dom.txt1, 0, {opacity:1});

  var wrapperWidth = creative.dom.textWrapper.clientWidth;
  var wrapperHeight = creative.dom.textWrapper.clientHeight;

  TweenLite.delayedCall(1, function() {
    TweenLite.to(creative.dom.txt2, 0.5, {opacity:1, scale:1, ease:Power2.easeOut});    
  });

  TweenLite.delayedCall(2.5, function() {
    TweenLite.to(creative.dom.txt2, 0.5, {opacity:0, scale:0.7, ease:Power2.easeOut});
    TweenLite.to(creative.dom.txt3, 0.5, {opacity:1, scale:1, ease:Power2.easeOut});    
  });
  TweenLite.delayedCall(4, function() {
    TweenLite.to(creative.dom.txt3, 0.5, {opacity:0, scale:0.7, ease:Power2.easeOut});
    TweenLite.to(creative.dom.txt4, 0.5, {opacity:1, scale:1, ease:Power2.easeOut});    
    TweenLite.to(creative.dom.cta, 1, {right:0, ease:Power2.easeOut});
  });
  TweenLite.delayedCall(5.5, function() {
    TweenLite.to(creative.dom.txt4, 0.5, {opacity:0, scale:0.7, ease:Power2.easeOut});
    TweenLite.to(creative.dom.txt5, 0.5, {opacity:1, scale:1, ease:Power2.easeOut});   
  });
  TweenLite.delayedCall(8, function() {
    TweenLite.to(creative.dom.textWrapper, 0.5, {height:0, width: 0, ease:Power2.easeOut});
    TweenLite.to([creative.dom.txt1, creative.dom.txt5], 0.1, {opacity:0, ease:Power2.easeOut}).delay(0.5);
    TweenLite.to(creative.dom.txt6, 0.1, {opacity:1, ease:Power2.easeOut}).delay(0.5);
    TweenLite.to(creative.dom.textWrapper, 0.5, {width:wrapperWidth, height:wrapperHeight, ease:Power2.easeOut}).delay(0.6);
  });
}

// ---------------------------------------------------------------------------------
// MAIN
// ---------------------------------------------------------------------------------

function exitClickHandler() {
  Enabler.exit('BackgroundExit');
}

/**
 *  Main onload handler
 */
window.addEventListener('load', preInit);